#ifndef MAP_H_INCLUDED
#define MAP_H_INCLUDED

#include <stdlib.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>

#define TILE_TAILLE 32
#define FX_FICHIER "fx.png"
#define SAISIE_MAX 255
#include "typedef.h"
#include "interface.h"



/// Fonctions d'initialisation / libration
void nouvelle_map(t_map *map); // Cre une nouvelle map vide
void charger_map(t_map *map); // Charge une map a partir d'un fichier .map
long sauvegarder_map(t_map *map); // Sauvegarde une map dans un fichier .map
void liberer_map(t_map * map); // Supprime les donnes de l'interface

/// Fonctions d'affichage / Rafraichissement
void afficher_map(t_map* map,t_interface* interface); // Blitte la map sur l'cran
void actualiser_minimap (t_partie *jeu, t_interface* interface); // Actualise la minimap  partir des donnes de la map
void obtenir_case(t_interface* interface); // Obtient les coordonnes de la case situe sous le pointeur de la souris

/// Fonction de conversion de donnes
void conversion_tile_tileset(long tile, long largeur,long hauteur, SDL_Rect *crop); // Recupre les coordonnes de rognage d'un tileset  partir du numro de tile

#endif // MAP_H_INCLUDED
